#define _USE_MATH_DEFINES
 
#include <bits/stdc++.h>
 
#ifndef ONLINE_JUDGE
    #define my_dbg
#endif
 
#define speed_up ios_base::sync_with_stdio(false); cin.tie(nullptr); cout.tie(nullptr);
#define open_files freopen("input.txt", "r", stdin), freopen("output.txt", "w", stdout);
#define all(x) x.begin(), x.end()
 
typedef long long ll;

using namespace std;

vector<pair<ll, ll>> vec;

struct segment {
    double l, r;
    bool empty = true;
    void update(double l, double r) {
        if (l > r) empty = true;
        else {
            empty = false;
            this->l = l, this->r = r;
        }
    }
};

void cross(vector<segment>& seg, segment fb) {
    vector<segment> new_seg;
    for (int i = 0; i < seg.size(); ++i) {
        segment curseg = seg[i];
        if (fb.l < curseg.l && fb.r > curseg.r) continue;
        if (fb.l < curseg.l) {
            if (fb.r <= curseg.r && fb.r >= curseg.l) {
                curseg.l = fb.r;
            }
        }
        else if (fb.l >= curseg.l && fb.r <= curseg.r && fb.r > fb.l) {
            segment curseg2;
            curseg2.update(curseg.l, fb.l);
            curseg.l = fb.r;
            new_seg.emplace_back(curseg2);
        }
        else if (fb.l > curseg.l) {
            if (fb.r >= curseg.r && curseg.r >= fb.l) {
                curseg.r = fb.l;
            }
        }
        else if (fb.l == curseg.l) {
            if (fb.r > curseg.r) {
                curseg.r = curseg.l;
            }
        }
        new_seg.emplace_back(curseg);
    }
    seg = new_seg;
}

bool check(double x) {
    segment firstseg;
    firstseg.update(0, 0);
    vector<segment> seg = {firstseg};
    ll t = 0;
    for (pair<ll, ll> y : vec) {
       ll dt = y.first - t;
       for (ll i = 0; i < seg.size(); ++i) {
           seg[i].update(seg[i].l - dt, seg[i].r + dt);
       }
       segment fb;
       fb.update(y.second - x, y.second + x);
       cross(seg, fb);
       if (seg.size() == 0) return false;
       t = y.first;
    }
    return true;
}

void solve() {
    ll n;
    cin >> n;
    vec.resize(n);
    for (ll i = 0; i < n; ++i) {
        cin >> vec[i].first >> vec[i].second;
    }
    sort(vec.begin(), vec.end());
    double l = 0, r = 1e18;
    while (r - l > 1e-4) {
        double mid = (l + r) / 2;
        bool flag = check(mid);
        if (!flag) {
            r = mid;
        }
        else l = mid;
    }
    cout << l << "\n";
}   
 
signed main() {
 
    speed_up
 
#ifdef my_dbg
    open_files
    clock_t processor_time = clock();
#endif
 
    signed t = 1;
    // cin >> t;
    while (t--) {
        solve();
    }
 
#ifdef my_dbg
    cout << "\nTIME : " << (clock() - processor_time) / (double)CLOCKS_PER_SEC;
#endif
 
}